# Logging a error reporting pro PHP projekty

- Monolog
- Sentry 

## Instalace

Extension je nutné zaregistrovat a nastavit název aplikace:
```yaml
extensions:
    reporting: XPInvest\Reporting\DI\ReportingExtension

reporting:
    name: inem.cz
```

Sentry je vždy aktivovaná. Ve výchozím stavu však chyby nikam neposílá. Pro posílání chyb
je třeba nastavit DSN daného projektu: 

```yaml
reporting:
    sentry:
        dsn: 'https://...@sentry.io/...'
        release: frontend/nazev-projektu@commit-hash
```

Pro trackování, v rámci kterého release jsou eventy posílány, lze nastavit release. Všechny frontend projekty musí dodržovat jednotný formát pro název releasu - `frontend/<název projektu>@commit-hash`. Více informací o releasech lze najít [v dokumentaci Sentry](https://docs.sentry.io/workflow/releases).

## Logování
Integrace počítá se zpracováním logů ze standardního výstupu (STDOUT).

- Automatické logování SQL queries v Doctrine DBAL

## Sentry
Všechny chyby (nezachycené výjimky, warningy, notices) jsou posílány do Sentry.
Všechny logy z aktuálního requestu jsou poslány jako
[Breadcrumbs](https://docs.sentry.io/enriching-error-data/breadcrumbs/?platform=php).

## Další Monolog handlery

Ve výchozím stavu jsou zaregistrované tyto handlery pro Sentry:
 - Sentry handler reportující chyby
 - Sentry handler přidávající Breadcrumbs
 - Stream handler, který vše loguje na standardní výstup (ať už v konzoli, nebo v rámci Apache)
 
 Každá registrovaná služba implementující rozhraní `Monolog\Handler\HandlerInterface` je automaticky použita jako další handler.

**Toto by mělo být využíváno minimálně. Většina handlerů by se nakonec měla dostat do tohoto balíčku, ať máme systém logování jednotný.**

## Konfigurace
Všechny konfigurační možnosti + defaultní hodnoty a typy:

```yaml
reporting:
    name: # string
    sentry:
        dsn: null # string | null (volitelné)
```
