# Logging a error reporting pro PHP projekty

- Monolog
- Sentry 

## Instalace

Extension je nutné zaregistrovat a nastavit název aplikace a cestu k log souboru (viz. [Logování](#logování)):
```yaml
parameters:
  hostname: ::gethostname()

extensions:
    reporting: XPInvest\Reporting\DI\ReportingExtension

reporting:
    name: inem.cz
    logFile: "%appDir/../logs/log-%hostname%.json # suffix hostname se hodí pro prevenci kolizí při běhu více instancí

```

Pro každý den logování je vytvořen nový soubor přidáním data na konec názvu souboru (viz. [RotatingFileHandler](https://github.com/Seldaek/monolog/blob/master/doc/02-handlers-formatters-processors.md#log-to-files-and-syslog))

Sentry je vždy aktivovaná. Ve výchozím stavu však chyby nikam neposílá. Pro posílání chyb
je třeba nastavit DSN daného projektu: 

```yaml
reporting:
    sentry:
        dsn: 'https://...@sentry.io/...'

```

## Logování
Integrace počítá s [vytěžováním logů přes Filebeat](https://gitlab.xpgroup.cz/infra/infra/wikis/infra/XPCloud/logging-elastic).

- Automatické logování SQL queries v Doctrine DBAL

## Sentry
Všechny chyby (nezachycené výjimky, warningy, notices) jsou posílány do Sentry.
Všechny logy z aktuálního requestu jsou poslány jako
[Breadcrumbs](https://docs.sentry.io/enriching-error-data/breadcrumbs/?platform=php).

## Další Monolog handlery

Ve výchozím stavu jsou zaregistrované tyto handlery pro Sentry:
 - Sentry handlerale jakákoliv služba
 - Sentry handler přidávající Breadcrumbs
 - File handler, který vytváří log soubory pro každý den. Drží vždy maximálně 7 souborů. To lze změnit přes option `logRetentionInDays`
 
 Každá registrovaná služba implementující rozhraní `Monolog\Handler\HandlerInterface` je automaticky použita jako další handler.

**Toto by mělo být využíváno minimálně. Většina handlerů by se nakonec měla dostat do tohoto balíčku, ať máme systém logování jednotný.**

## Konfigurace
Všechny konfigurační možnosti + defaultní hodnoty a typy:

```yaml
reporting:
    name: # string
    logFile: # string
    logRetentionInDays: 7 # int >= 0, 0 znamená neomezeně (volitelné)
    sentry:
        dsn: null # string | null (volitelné)
```
