<?php

declare(strict_types=1);

namespace XPInvest\Reporting\Sentry;

use Sentry\ClientBuilder;
use Sentry\Integration\ModulesIntegration;
use Sentry\Integration\RequestIntegration;
use Sentry\Options;
use Sentry\State\Hub;
use Sentry\State\Scope;

final class HubFactory
{
    /**
     * @param string|null $dsn Sentry DSN (access token) or null to create Hub that does not report anything
     * @param callable[] $eventProcessors
     */
    public static function create(?string $dsn, array $eventProcessors) : Hub
    {
        $options = new Options(['dsn' => $dsn]);
        $options->setAttachStacktrace(true);
        $options->setIntegrations([
            new ModulesIntegration(),
            new RequestIntegration(),
        ]);

        $client = (new ClientBuilder($options))->getClient();

        $scope = new Scope();

        foreach ($eventProcessors as $processor) {
            $scope->addEventProcessor($processor);
        }

        return new Hub($client, $scope);
    }
}
