<?php

declare(strict_types=1);

namespace XPInvest\Reporting\DBAL;

use Psr\Log\LoggerInterface;

final class SQLLogger implements \Doctrine\DBAL\Logging\SQLLogger
{
    /** @var LoggerInterface */
    private $logger;

    /** @var string */
    private $message;

    /** @var array<string, mixed> */
    private $context;

    /** @var float */
    private $startTime;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @param string $sql
     * @param mixed[]|null $params
     * @param mixed[]|null $types
     */
    public function startQuery($sql, ?array $params = null, ?array $types = null) : void
    {
        $this->message = 'Query: ' . $sql;
        $this->context = [
            'sql' => $sql,
            'params' => $params,
            'types' => $types,
        ];

        $this->startTime = microtime(true);
    }

    public function stopQuery() : void
    {
        $time = (int) round((microtime(true) - $this->startTime) * 1000);
        $this->logger->info(
            sprintf('Query %s finished in %d ms', $this->context['sql'], $time),
            $this->context + ['time' => $time]
        );
    }
}
