<?php declare(strict_types=1);

namespace XPInvest\PayUButton\Order;

use Money\Money;
use Nette\SmartObject;
use XPInvest\PayUButton\Exceptions\InvalidArgumentException;

/**
 * @property-read string $id
 * @property-read string $orderId
 * @property-read Money $amount
 * @property-read string $status
 */
class Payment
{

    use SmartObject;

    const PENDING = 'PENDING';
    const WAITING_FOR_CONFIRMATION = 'WAITING_FOR_CONFIRMATION';
    const COMPLETED = 'COMPLETED';
    const CANCELED = 'CANCELED';
    const REJECTED = 'REJECTED';

    /** @var string */
    private $id;

    /** @var string */
    private $orderId;

    /** @var Money */
    private $amount;

    /** @var string */
    private $status;

    /**
     * Payment constructor.
     * @param string $id
     * @param string $orderId
     * @param Money $amount
     * @param string $status
     * @throws InvalidArgumentException
     */
    public function __construct(string $id, string $orderId, Money $amount, string $status)
    {
        $this->id = $id;
        $this->orderId = $orderId;
        $this->amount = $amount;

        $statuses = [self::PENDING, self::WAITING_FOR_CONFIRMATION, self::COMPLETED, self::CANCELED, self::REJECTED];
        if (!in_array($status, $statuses)) {
            throw new InvalidArgumentException('Unknown status name.');
        }

        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getOrderId(): string
    {
        return $this->orderId;
    }

    /**
     * @return Money
     */
    public function getAmount(): Money
    {
        return $this->amount;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }
}
