<?php declare(strict_types=1);

namespace XPInvest\PayUButton\Order;

use Nette\SmartObject;
use Nette\Utils\Validators;
use XPInvest\PayUButton\Exceptions\InvalidArgumentException;

/**
 * @property-read string $email
 * @property-read NULL|string $phoneNumber
 * @property-read NULL|string $firstName
 * @property-read NULL|string $lastName
 */
class Customer
{

    use SmartObject;

    /** @var string */
    private $email;

    /** @var NULL|string */
    private $phoneNumber;

    /** @var NULL|string */
    private $firstName;

    /** @var NULL|string */
    private $lastName;

    /** @var string */
    private $language;

    /**
     * @throws InvalidArgumentException
     */
    public function __construct(
        string $email,
        string $phoneNumber = null,
        string $firstName = null,
        string $lastName = null,
        string $language = 'cs'
    ) {
        if (!Validators::isEmail($email)) {
            throw new InvalidArgumentException('Invalid e-mail address.');
        }
        $this->email = $email;
        $this->phoneNumber = $phoneNumber;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->language = $language;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return NULL|string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @return NULL|string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @return NULL|string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }

}
