<?php declare(strict_types=1);

namespace XPInvest\PayUButton\Factory;

use XPInvest\PayUButton\Order;

class NewOrderArrayFactory
{

    /**
     * @param Order $order
     * @param string $clientId
     * @param string $continueUrl
     * @param string $notifyUrl
     * @return array
     */
    public static function create(Order $order, string $clientId, string $continueUrl, string $notifyUrl): array
    {
        $data = [
            'continueUrl' => $continueUrl,
            'notifyUrl' => $notifyUrl,
            'customerIp' => $order->getIp(),
            'merchantPosId' => $clientId,
            'description' => $order->getDescription(),
            'currencyCode' => $order->getTotal()->getCurrency()->getCode(),
            'totalAmount' => $order->getTotal()->getAmount(),
            'extOrderId' => $order->getId(),
            'settings' => [
                'invoiceDisabled' => true,
            ],
        ];

        foreach ($order->getProducts() as $i => $product) {
            $data['products'][$i]['name'] = $product->getName();
            $data['products'][$i]['unitPrice'] = $product->getUnitPrice()->getAmount();
            $data['products'][$i]['quantity'] = $product->getUnits();
        }

        if ($order->getCustomer()) {
            $data['buyer']['email'] = $order->getCustomer()->getEmail();
            $data['buyer']['phone'] = $order->getCustomer()->getPhoneNumber();
            $data['buyer']['firstName'] = $order->getCustomer()->getFirstName();
            $data['buyer']['lastName'] = $order->getCustomer()->getLastName();
            $data['buyer']['language'] = $order->getCustomer()->getLanguage();
        }

        return $data;
    }
}
