<?php declare(strict_types=1);

namespace XPInvest\PayUButton\Response;

class NewOrderResponse
{

	/** @var string */
	private $id;

	/** @var string */
	private $orderId;

	/** @var string */
	private $redirectUrl;

	/**
	 * NewOrderResponse constructor.
	 * @param string $id
	 * @param string $orderId
	 * @param string $redirectUrl
	 */
	public function __construct(string $id, string $orderId, string $redirectUrl)
	{
		$this->id = $id;
		$this->orderId = $orderId;
		$this->redirectUrl = $redirectUrl;
	}

	/**
	 * @return string
	 */
	public function getId(): string
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getOrderId(): string
	{
		return $this->orderId;
	}

	/**
	 * @return string
	 */
	public function getRedirectUrl(): string
	{
		return $this->redirectUrl;
	}

}
