<?php declare(strict_types=1);

namespace XPInvest\PayUButton\Order;

use Money\Money;
use Nette\SmartObject;
use XPInvest\PayUButton\Exceptions\InvalidArgumentException;

/**
 * @property-read string $name
 * @property-read Money $unitPrice
 * @property-read int $units
 * @property-read Money $total
 */
class Product
{

	use SmartObject;

	/** @var string */
	private $name;

	/** @var Money */
	private $unitPrice;

	/** @var int */
	private $units;

	/**
	 * Product constructor.
	 * @param string $name
	 * @param Money $unitPrice
	 * @param int $units
	 * @throws InvalidArgumentException
	 */
	public function __construct(string $name, Money $unitPrice, int $units)
	{
		$this->name = $name;
		$this->unitPrice = $unitPrice;
		if($units < 1) {
			throw new InvalidArgumentException('Number of units must be bigger than zero.');
		}
		$this->units = $units;
	}

	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}

	/**
	 * @return Money
	 */
	public function getUnitPrice(): Money
	{
		return $this->unitPrice;
	}

	/**
	 * @return int
	 */
	public function getUnits(): int
	{
		return $this->units;
	}

	/**
	 * @return Money
	 */
	public function getTotal(): Money
	{
		return $this->unitPrice->multiply($this->units);
	}

}
