# PayU Button

Rozšíření pro platební bránu PayU a jejich REST API klienta. Více informací k chování je k nalezení přímo na stránkách [PayU](http://developers.payu.com/en/overview.html).

## Instalace

Přes composer stačí načíst balíček `xpinvest/payu-button`.

```sh
$ composer require xpinvest/payu-button
```

### Požadavky a externí závislosti knihovny

  - PHP 7.0 a vyšší
  - [nette/application](https://github.com/nette/application) >= 2.4
  - [nette/caching](https://github.com/nette/caching) >= 2.5
  - [nette/di](https://github.com/nette/di) >= 2.4
  - [nette/http](https://github.com/nette/http) >= 2.4
  - [nette/utils](https://github.com/nette/utils) >= 2.4
  - [openpayu/openpayu](https://github.com/openpayu/openpayu) >= 2.2
  - [moneyphp/money](https://github.com/moneyphp/money) >= 3.0

Dále je třeba zaregistrovat rozšíření v konfiguračním souboru `config.neon` a zadat přístupové údaje získané z administrace účtu v PayU.

```yaml
payu:
	sandbox: true
    clientId: %payu.clientId%
    secret: %payu.secret%
    key: %payu.key%

extensions:
	payu: XPInvest\PayUButton\DI\PayUButtonExtension
```

Pak už jen stačí připravit část, kde se bude platba provádět a pak část, která zpracuje odpověď z PayU.

## Příklad vyvolání platby

Možností implementace je několik - je možno použít tlačíko přímo z rozšíření (případně mu nastavit vlastní šablonu - viz Nette a práce s komponentama) a nebo bez využití tlačítka viz příklad níže.

```php
<?php declare(strict_types=1);

class SomePresenter extends \Nette\Application\UI\Presenter
{

    /** @var \XPInvest\PayUButton\UI\IButtonFactory */
    private $payButtonFactory;

    public function renderPay()
    {
        $this['payUPayButton']->handlePay();
    }

    protected function createComponentPayUPayButton()
    {
      $control = $this->payButtonFactory->create();
      $control->onBeforePay[] = function() use ($control) {
        /** @var $order \XPInvest\PayUButton\Order */
        /** @var $link string - URL kam nás vrátí PayU - např. $this->link('//:PayU:'); */
        $control->setOrder($order)->setNotifyUrl($link);
      };
      $control->onSuccess[] = function(\XPInvest\PayUButton\Order\Payment $payment) {
          dump($payment);
          // + vlastní zpracování
      };
      $control->onError[] = function(\XPInvest\PayUButton\Exceptions\PayUException $e) {
          dump($e);
          // + vlastní zpracování
      };
      return $control;
    }

```

## Příklad zpracování odpovědi z PayU

```php
<?php declare(strict_types=1);

class PayUPresenter extends \Nette\Application\UI\Presenter
{

    /** @var \XPInvest\PayUButton\Client */
    private $payUClient;

    try {
        /** @var $order \XPInvest\PayUButton\Order */
        $order = $this->payUClient->consumeOrderPaymentNotificationRequest($this->getHttpRequest());
        // vlastní zpracování (potvrzení platby)
        $this->payUClient->sendSuccessResponse();
    } catch(\XPInvest\PayUButton\Exceptions\PayUApiException $e) {
        $this->payUClient->sendErrorResponse();
    }

}
```
