## Nette Smsbrána.cz

Klient pro sms bránu Smsbrána.cz. Naprogramovány základní dvě funkce brány - odesílání sms a získání stavu kreditu. 
Klient používá pouze zabezpečený přístup k bráně. [dokumentace](http://neogate.cz/files/smsconnect-http.pdf)

## Instalace

Přes composer nainstalovat balíček `xpinvest/nette-smsbrana.cz`.

```sh
$ composer require xpinvest/nette-smsbrana.cz
```

### Požadavky a externí závislosti knihovny

  - PHP 7.0 a vyšší
  - [nette/application](https://github.com/nette/application) >= 2.4
  - [nette/di](https://github.com/nette/di) >= 2.4
  - [nette/utils](https://github.com/nette/utils) >= 2.4
  - [openpayu/openpayu](https://github.com/openpayu/openpayu) >= 2.2
  - [guzzlehttp/guzzle](https://github.com/guzzle/guzzle) >= 6.3
  
 Dále je třeba zaregistrovat rozšíření v konfiguračním souboru `config.neon` a zadat přístupové údaje získané z administrace účtu v sms brány.

```yaml
smsClient:
	login: %smsClient.login%
	password: %smsClient.password%

extensions:
	smsClient: XPInvest\SmsBranaCz\DI\SmsBranaCzExtension
```

## Příklad zaslání sms a dotazu na zůstatek

```php
<?php declare(strict_types=1);

class FooClass
{

    /** @var \XPInvest\SmsBranaCz\ISmsClient */
    private $smsClient;
	
	public function __construct(\XPInvest\SmsBranaCz\ISmsClient $smsClient)
	{
		$this->smsClient = $smsClient;
	}
	
	public function handleSendSms()
	{
		try {
			$sms = new \XPInvest\SmsBranaCz\Sms('+420123456789', 'Text of sms message.');
			$response = $this->smsClient->send($sms);
			echo 'Message cost was ' . $response->getPrice() . ' CZK';
		} catch(\XPInvest\SmsBranaCz\Exceptions\SmsClientException $e) {
			//Handle exception
		}
	}
	
	public function showMeCreditAmount()
	{
		try {
			$response = $this->smsClient->getCreditInfo();
			echo 'Credit amount: ' . $response . ' CZK';
		} catch(\XPInvest\SmsBranaCz\Exceptions\SmsClientException $e) {
			//Handle exception
		}
	}

```