<?php declare(strict_types=1);

namespace XPInvest\SmsBranaCz;

use XPInvest\SmsBranaCz\Sms;
use XPInvest\SmsBranaCz\Responses\SmsResponse;
use XPInvest\SmsBranaCz\Exceptions\SmsClientException;

interface ISmsClient
{

	/**
	 * @param Sms $sms
	 * @return SmsResponse
	 * @throws SmsClientException
	 */
	public function send(Sms $sms): SmsResponse;

	/**
	 * @return float
	 * @throws SmsClientException
	 */
	public function getCreditInfo(): float;

}
