<?php declare(strict_types=1);

namespace XPInvest\SmsBranaCz\Responses;

class SmsResponse
{

	/** @var float */
	private $price;

	/** @var int */
	private $smsCount;

	/** @var float */
	private $credit;

	/** @var int */
	private $smsId;

	/**
	 * SmsResponse constructor.
	 * @param float $price
	 * @param int $smsCount
	 * @param float $credit
	 * @param int $smsId
	 */
	public function __construct(float $price, int $smsCount, float $credit, int $smsId)
	{
		$this->price = $price;
		$this->smsCount = $smsCount;
		$this->credit = $credit;
		$this->smsId = $smsId;
	}

	/**
	 * @return float
	 */
	public function getPrice(): float
	{
		return $this->price;
	}

	/**
	 * @return int
	 */
	public function getSmsCount(): int
	{
		return $this->smsCount;
	}

	/**
	 * @return float
	 */
	public function getCredit(): float
	{
		return $this->credit;
	}

	/**
	 * @return int
	 */
	public function getSmsId(): int
	{
		return $this->smsId;
	}

}
