<?php declare(strict_types=1);

namespace XPInvest\SmsBranaCz\Factories;

use Nette\Utils\Random;
use XPInvest\SmsBranaCz\Utils\QueryDateTime;

class RequestFactory
{

	/**
	 * @param string $action
	 * @param array $requestParameters
	 * @param string $login
	 * @param string $password
	 * @return array
	 */
	public static function createQueryParameters(string $action, array $requestParameters, string $login, string $password): array
	{
		$time = new QueryDateTime;
		$sul = Random::generate(45);
		$hash = md5($password.strval($time).$sul);

		$auth = [
			'login' => $login,
			'time' => strval($time),
			'sul' => $sul,
			'auth' => $hash,
			'action' => $action
		];

		foreach($requestParameters as $key => $parameter) {
			if(!$parameter) {
				unset($requestParameters[$key]);
			}
		}

		return array_merge($auth, $requestParameters);
	}

}
