<?php declare(strict_types=1);

namespace XPInvest\SmsBranaCz\DI;

use Nette\DI\CompilerExtension;
use Nette\DI\Config\Helpers;
use XPInvest\SmsBranaCz\SmsClient;

class SmsBranaCzExtension extends CompilerExtension
{

	/** @var array */
	private $defaults = [
		'login' => NULL,
		'password' => NULL
	];

	public function loadConfiguration()
	{
		$config = Helpers::merge($this->getConfig(), $this->defaults);

		$builder = $this->getContainerBuilder();

		$builder->addDefinition($this->prefix('smsClient'))
			->setFactory(SmsClient::class)
			->setArguments([$config['login'], $config['password']]);
	}

}
