<?php

declare(strict_types=1);

namespace Fmasa\Messenger\Exceptions;

use Exception;

use Nette\DI\ServiceDefinition;
use function array_map;
use function implode;
use function sprintf;

final class MultipleHandlersFound extends Exception
{
    /**
     * @param ServiceDefinition[] $handlers
     */
    public static function fromHandlerClasses(string $messageName, array $handlers): self
    {
        return new self(sprintf(
            'There are multiple handlers for message "%s": %s',
            $messageName,
            implode(
                ', ',
                array_map(
                    static function (ServiceDefinition $definition): string {
                        return $definition->getType();
                    },
                    $handlers
                )
            )
        ));
    }
}
